package jamezo97.clonecraft.entity.clone;

import jamezo97.clonecraft.Logger;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;

public class FieldList {
	
	ArrayList<Field> allFields = new ArrayList<Field>();
	
	HashMap<Integer, Field> subIdToField = new HashMap<Integer, Field>();
	
	HashMap<Field, Integer> fieldToSubId = new HashMap<Field, Integer>();
	
	public void addField(Field field, int subID){
		if(!subIdToField.containsKey(subID)){
			allFields.add(field);
		}else{
			Logger.error("Duplicate Sub-Ids... :(");
		}
		subIdToField.put(subID, field);
		fieldToSubId.put(field, subID);
	}
	
	public ArrayList<Field> getAllField(){
		return allFields;
	}
	
	public Field getFieldBySubId(int subId){
		return subIdToField.get(subId);
	}

	public int getId(Field field) {
		return fieldToSubId.get(field);
	}

}
